//
// fgraph.cc
//  
// Made by vicen
// Login   <vicen@localhost.localdomain>
// 
// Started on  Wed Apr 19 20:52:08 2006 vicen
// Started on  Wed Apr 19 20:52:08 2006 vicen
//

// TODO : remove var in the Index class to allow multivalued vars
//        check if good results setting the residuals
//        symmetrize the COND results
#include "fgraph.hh"

#define NORM_LR             2           // normalization of the LR msg:
#define MAX_LENGTH_STRING  10 

// VERBOSITY:
// 1 basic output (only diffs & converg)
// 2 belief values
// 3 iterations

void FGraph::graph2Dot(const char *filename)
{
  VectorVertex vars, factors;

  // create dot file
  std::ofstream fout(filename);
  fout << "digraph G {" << std::endl;
  fout << "digraph[size=\"100,100\"];" << std::endl;

  // var nodes 
  fout << "node[shape=circle,width=0.3,height=0.3,fixedsize=true];" << std::endl;
  std::pair<VertexIt, VertexIt> it_var = vertices(*g); 
  while (it_var.first != it_var.second) {
    if ((*g)[*it_var.first].type == VAR) {
      fout << "\t" << (*g)[*it_var.first].label;
      fout << "[style=\"setlinewidth(1)\",label=" << (*g)[*it_var.first].label << "];" << std::endl;
    }
    it_var.first++;
  }

  // factor nodes
  fout << "node[shape=box,width=0.3,height=0.3,fixedsize=true];" << std::endl;
  std::pair<VertexIt, VertexIt>  sit = vertices(*g); 
  while (sit.first != sit.second) {
    if ((*g)[*sit.first].type == FACTOR) {
      fout << "\tp" << (*g)[*sit.first].label;
      fout << "[style=\"setlinewidth(1)\",label=" << char(97+(*g)[*sit.first].label) << "];" << std::endl;
    }
    sit.first++;
  }

  // rest
  EdgeIt ei, ei_end;
  for (tie(ei, ei_end) = edges((*g)); ei != ei_end; ei++) {
    Edge e = *ei;
    if (((*g))[source(e, (*g))].type == FACTOR) {

      // Factor to Var (m message)
      VProb m = getBPm(e, false);
      VProb n = getBPn(e, false);
      fout << "\tp" << ((*g))[source(e, (*g))].label << " -> " << ((*g))[target(e, (*g))].label;
      fout << "[style=\"setlinewidth(1)\",fontsize=15,fontcolor=red,label=" <<  std::setprecision(3) << m[0]-m[1] << "];" << std::endl;

      // Var to Factor (n message)
      fout << "\t" << ((*g))[target(e, (*g))].label << " -> p" << ((*g))[source(e, (*g))].label;
      fout << "[style=\"setlinewidth(1)\",fontsize=15,fontcolor=blue,label=" <<  std::setprecision(3) << n[0]-n[1] << "];" << std::endl;
     }
    else std::cout << "????" << std::endl;
  }
  fout << "}" << std::endl;
  fout.close();
}

FGraph::FGraph(std::string filename, TBPVariant bp_variant)
{
  // check the format by extension
	// .fg  : libDAI
	// .pot : bbcore
  m_max_factor_value = -1.;
	
  // inits
  m_bp_variant = bp_variant;
  m_nedges = 0;
  m_nvars = 0;
  m_nfactors = 0;
	//  m_r = gsl_rng_alloc(gsl_rng_mrg);
  m_filename = filename;
  m_logZ_bp = -1.;
  m_logZ_exact = -1.;
  m_negpot = false;

  // create the Graph
  g = new BGraph();

  // read from file
  std::ifstream file_in(filename.c_str());
  if (!file_in) throw "Factor Graph file " + filename + " not found!";

  // temporal set for the variables
  std::set<PVertex> svars;

  // start reading from stream
  int labelf = 0;
  char aline[100];
	int posdot = filename.find_last_of('.')+1;
	std::string extension(filename.substr(posdot, filename.length()-posdot));
	if (extension == "fg") { 
		std::cout << "READING in libDAI format" << std::endl;
    do {
      file_in.getline(aline, 100);
  		if (file_in.eof()) throw "eof found!";
  	} while ( (aline[0] == '#') || (atoi(aline) == 0) );
  
  	std::cout << aline << " factors"; std::cout.flush();
		m_nfactors = atoi(aline);
  }
	else if (extension == "pot") {
		std::cout << "READING in bbcore format" << std::endl;
	}

  // temporal vector for the variables of a factor
  std::vector<std::vector<PVertex> > vfactorvars;

  // read the factor variables
  int nvals; uint nvars;
	std::string s;
	if (extension == "fg")
    file_in >> nvars;

  while (!file_in.eof()) {

  //     std::cout << "\t" << nvars << " vars" << std::endl;

    // add the variables to the set
    int totalsize = 1;
  	std::vector<PVertex> vvar;
		if (extension == "fg") { 
			std::vector<int> vlabels(nvars), vsizes(nvars);
      for (uint v=0; v<nvars; v++) file_in >> vlabels[v];
      for (uint v=0; v<nvars; v++) file_in >> vsizes[v];
  
      for (uint v=0; v<nvars; v++) {
        PVertex var(VAR, vlabels[v], vsizes[v]);
        svars.insert(var);
  			vvar.push_back(var);
        totalsize *= vsizes[v];
      }
      vfactorvars.push_back(vvar);
		} else {

			getline(file_in, s);
			std::cout << s << std::endl;
			std::cout << "eof? " << file_in.eof() << std::endl;
			if ( file_in.eof() ) break;
			std::stringstream str(s);
	 		int label_var;
			nvars = 0;
  		while (str >> label_var) {
        PVertex var(VAR, label_var, 2);
				totalsize *= 2;
	      svars.insert(var);
  			vvar.push_back(var);
				nvars++;
  		}
      vfactorvars.push_back(vvar);
		}

    // read the factor values
    Real p;
    VProb prob(totalsize, 0.);
		if (extension == "fg") { 
      file_in >> nvals;
  		for (int v=0, i; v<nvals; v++) {
        file_in >> i >> p;
        prob[i] = p;
        if (fabsl(p) > m_max_factor_value)
          m_max_factor_value = fabsl(p);
  			if (p < 0.) {
  				m_negpot = true;
  				std::cout << "NEG POT" << std::endl;
  		  }
      }
		}
		else {

			if (!getline(file_in, s)) break;
			std::cout << s << std::endl;
			std::stringstream str(s);
			int i=0;
			while (str >> p) {
				prob[i] = p;
				i++;
			}
			std::cout << setprecision(14) << prob << std::endl;
			m_nfactors++;
		}

    // add the factor to the graph
    BGraph::vertex_descriptor v = add_vertex(*g);
    (*g)[v].type = FACTOR;
    (*g)[v].label = labelf;
    (*g)[v].size = prob.size();
    (*g)[v].psi = prob;

		labelf++;

    // next factor
		if (extension == "fg") file_in >> nvars;
  }

	std::cout << "boost" << std::endl;

  // the total number of vars
  m_nvars = svars.size();

  // add the variables to the graph using the svars set
  // they are inserted in the labeling order
  for (std::set<PVertex>::iterator it = svars.begin(); it != svars.end(); it++) {
    BGraph::vertex_descriptor v = add_vertex(*g);
    (*g)[v].type = VAR;
    (*g)[v].label = (*it).label;
    (*g)[v].size = (*it).bel.size();   
    (*g)[v].bel = (*it).bel;           // the belief is initialized to 1/nvals (see global.hh)
    //m_mapvar[(*it).label] = v;
  }

  // add the edges between factors and variables using vfactorvars
  std::pair<VertexIt, VertexIt> vpf = vertices(*g), vpv;

  // vpf iterates over factors and vpv iterates over variables
  for (uint f = 0; (f < m_nfactors); vpf.first++, f++) {

    // Indices of the factor f
    PIndex idx;

    // use vfactorvars to get the variables of the factor
    int nvar = 0;
    for (std::vector<PVertex>::iterator i = vfactorvars[f].begin(); i != vfactorvars[f].end(); i++) {

      // set the vpv iterator to the begining of the variable nodes
      vpv = vertices(*g); vpv.first += m_nfactors;

      // find the descriptor of the corresponding variable node
      while ( ((*g)[*vpv.first].label != (*i).label) && (vpv.first != vpv.second) ) vpv.first++;

      // add the edge
      addEdge(*vpf.first, *vpv.first, *g, (*g)[*vpv.first].size, nvar);

      // add the variable to the index
      idx.addVar((*g)[*vpv.first].size);

      m_nedges++;
      nvar++;
    }

    // add the index to the factor
    (*g)[*vpf.first].index = idx;
  }

  buildFactors();        // vector of factors
  buildVarsPos();        // vector of vars and map of positions
  buildVarsSizes();      // vector of vars sorted by size

  std::pair<VertexIt, VertexIt> iit = vertices(*g);
	while (iit.first != iit.second) {
		if (degree(*iit.first, *g) == 0)
			std::cout << *iit.first << " has no neighbors!" << std::endl;
		iit.first++;
	}		  

	m_exact = false;
	m_error_bp = -1;

  /*  ofstream bp_max("bp_max_factor.m");
  bp_max << setprecision(15) << m_max_factor_value << endl;
  bp_max.close();*/
	std::cout << "fgraph" << std::endl;

/*



  // inits
  m_bp_variant = bp_variant;
  m_nedges = 0;
  m_nvars = 0;
  m_nfactors = 0;
	//  m_r = gsl_rng_alloc(gsl_rng_mrg);
  m_filename = filename;
  m_logZ_bp = -1.;
  m_logZ_exact = -1.;
  m_negpot = false;

  // create the Graph
  g = new BGraph();

  // read from file
  std::ifstream file_in(filename.c_str());
  if (!file_in) throw "Factor Graph file " + filename + " not found!";

  // temporal set for the variables
  std::set<PVertex> svars;

  // start reading from stream
  int labelf = 0;
  char aline[100];

	int posdot = filename.find_last_of('.')+1;
	std::string extension(filename.substr(posdot, filename.length()-posdot));
	if (extension == "fg") { 
		std::cout << "READING in libDAI format" << std::endl;
    do {
      file_in.getline(aline, 100);
  		if (file_in.eof()) throw "eof found!";
  	} while ( (aline[0] == '#') || (atoi(aline) == 0) );
  
  	std::cout << aline << " factors"; std::cout.flush();
  }
	else if (extension == "pot") {
		std::cout << "READING in bbcore format" << std::endl;
	}

  // temporal vector for the variables of a factor
  std::vector<std::vector<PVertex> > vfactorvars;

	// read the factor variables
  int nvals;
	uint nvars = 0;
	if (extension == "fg")
    file_in >> nvars;

	std::string s;
	std::cout << setprecision(14) << std::endl;
	while (getline(file_in, s)) {

		// add the variables to the set
    std::vector<int> vlabels, vsizes;

		// read var labels
    int totalsize = 1;
		if (extension == "fg") {

      std::cout << "\t" << nvars << " vars" << std::endl;
			vlabels.resize(nvars);
			vsizes.resize(nvars);
			for (uint v=0; v<nvars; v++) file_in >> vlabels[v];
	    for (uint v=0; v<nvars; v++) {
				file_in >> vsizes[v];
				totalsize *= vsizes[v];
			}
		}
		else {
			nvars = 0;
			std::cout << file_in.eof() << std::endl;
			std::cout << s << std::endl;
			std::stringstream str(s);
	 		int label_var;
  		while (str >> label_var) {
				vlabels.push_back(label_var);
				vsizes.push_back(2);
				totalsize *= 2;
				nvars++;
  		}
		}

		std::cout << "labels sizes" << std::endl;
    for (uint v=0; v<nvars; v++) {
			std::cout << vlabels[v] << " " << vsizes[v] << std::endl;
		} 

		// insert them into a factor
		std::vector<PVertex> vvar;
    for (uint v=0; v<nvars; v++) {
      PVertex var(VAR, vlabels[v], vsizes[v]);
      svars.insert(var);
			vvar.push_back(var);
    }
    vfactorvars.push_back(vvar);

    // read the factor values
		VProb prob(totalsize, 0.);
	  Real p;
		if (extension == "fg") {
	    file_in >> nvals;
	    for (int v=0, i; v<nvals; v++) {
	      file_in >> i >> p;
	      prob[i] = p;
//// uncomment this if you want to normalize using the Linf norm
//			if (p < 0.) {
//				m_negpot = true;
//				std::cout << "NEG POT" << std::endl;
//		  }
		  }
		}
		else {
			getline(file_in, s);
			std::cout << s << std::endl;
			std::stringstream str(s);
			int i=0;
			while (str >> p) {
				prob[i] = p;
				i++;
			}
		}

		std::cout << "factor : "<< std::endl;
	for (uint pp=0; pp < prob.size(); pp++)
		std::cout << "\t" << prob[pp] << std::endl;

    // add the factor to the graph
    BGraph::vertex_descriptor v = add_vertex(*g);
    (*g)[v].type = FACTOR;
    (*g)[v].label = labelf;
    (*g)[v].size = prob.size();
    (*g)[v].psi = prob;

    m_nfactors++;

    // next factor
		if (extension == "fg")
	    file_in >> nvars;
  }

  // the total number of vars
  m_nvars = svars.size();

  // add the variables to the graph using the svars set
  // they are inserted in the labeling order
  for (std::set<PVertex>::iterator it = svars.begin(); it != svars.end(); it++) {
    BGraph::vertex_descriptor v = add_vertex(*g);
    (*g)[v].type = VAR;
    (*g)[v].label = (*it).label;
    (*g)[v].size = (*it).bel.size();   
    (*g)[v].bel = (*it).bel;           // the belief is initialized to 1/nvals (see global.hh)
    //m_mapvar[(*it).label] = v;
  }

  // add the edges between factors and variables using vfactorvars
  std::pair<VertexIt, VertexIt> vpf = vertices(*g), vpv;

  // vpf iterates over factors and vpv iterates over variables
  for (uint f = 0; (f < m_nfactors); vpf.first++, f++) {

    // Indices of the factor f
    PIndex idx;

    // use vfactorvars to get the variables of the factor
    int nvar = 0;
    for (std::vector<PVertex>::iterator i = vfactorvars[f].begin(); i != vfactorvars[f].end(); i++) {

      // set the vpv iterator to the begining of the variable nodes
      vpv = vertices(*g); vpv.first += m_nfactors;

      // find the descriptor of the corresponding variable node
      while ( ((*g)[*vpv.first].label != (*i).label) && (vpv.first != vpv.second) ) vpv.first++;

      // add the edge
      addEdge(*vpf.first, *vpv.first, *g, (*g)[*vpv.first].size, nvar);

      // add the variable to the index
      idx.addVar((*g)[*vpv.first].size);

      m_nedges++;
      nvar++;
    }

    // add the index to the factor
    (*g)[*vpf.first].index = idx;
  }

  buildFactors();        // vector of factors
  buildVarsPos();        // vector of vars and map of positions
  buildVarsSizes();      // vector of vars sorted by size

  std::pair<VertexIt, VertexIt> iit = vertices(*g);
	while (iit.first != iit.second) {
		if (degree(*iit.first, *g) == 0)
			std::cout << *iit.first << " has no neighbors!" << std::endl;
		iit.first++;
	}		  

	m_exact = false;
	m_error_bp = -1;
	
	std::cout << "fgraph loaded" << std::endl;
*/

}

std::ostream& operator<< (std::ostream& os, FGraph& fg)
{
  // create new file with the tree
  os << fg.m_nfactors << std::endl << std::endl;
  std::pair<VertexIt, VertexIt> iit = vertices(*fg.g);
  while (iit.first != iit.second) {
    Vertex a = *iit.first;
    if ((*fg.g)[a].type == FACTOR) {
      os << degree(a, *fg.g) << std::endl;
      OutEdgeIt j_begin, j_end;
      for (tie(j_begin, j_end) = out_edges(a, (*fg.g)); j_begin != j_end; j_begin++)
				os << (*fg.g)[target(*j_begin, *fg.g)].label << " ";
			os << std::endl;
      for (tie(j_begin, j_end) = out_edges(a, (*fg.g)); j_begin != j_end; j_begin++)
				os << (*fg.g)[target(*j_begin, *fg.g)].size << " ";
      os << std::endl;
      os << (*fg.g)[a].size << std::endl;
      for (int i=0; i<(*fg.g)[a].size; i++)
				os << i << "\t" << (*fg.g)[a].psi[i] << std::endl;
      os << std::endl;
    }
    iit.first++;
  }
  return os;
}

void FGraph::addEdge(const Vertex &s,
		     const Vertex &t,
		     BGraph &_g,
		     const uint &size,
		     const uint &pos)
{
  std::pair<Edge, bool> ce = add_edge(s, t, _g);
  VProb prob(_g[t].size, 1.);///_g[t].size);
  _g[ce.first].m_old = prob; _g[ce.first].m_new = prob;
  _g[ce.first].n_old = prob; _g[ce.first].n_new = prob;
  _g[ce.first].pos_index = pos;
}

void FGraph::buildFactors()
{
  std::pair<VertexIt, VertexIt> itf = vertices(*g);
  for (uint f = 0; (f < m_nfactors); itf.first++, f++)
    m_factors.push_back(*itf.first);
}

void FGraph::buildVarsSizes()
{
  // sort the variables by size
  std::pair<VertexIt, VertexIt> vpv = vertices(*g); vpv.first += m_nfactors;
  while (vpv.first != vpv.second) {
    VectorVertexIt ii = m_vars_sizes.begin();
    bool fnd = false;
    while (!fnd && (ii != m_vars_sizes.end())) {
      if ( (*g)[*ii].size > (*g)[*vpv.first].size ) fnd = true;
      else ii++;
    }
    m_vars_sizes.insert(ii, *vpv.first);
    vpv.first++;
  }
}

void FGraph::buildVarsPos()
{
  // sort the variables by label
  std::pair<VertexIt, VertexIt> vpv = vertices(*g); vpv.first += m_nfactors;
  int pos = 0;
  while (vpv.first != vpv.second) {
    m_vars_labels.push_back(*vpv.first);
    m_vars_pos[*vpv.first] = pos;
    vpv.first++;
    pos++;
  }
	for (int ii = 0; ii < (int)m_vars_labels.size(); ii++) {
		m_label2idx[(*g)[m_vars_labels[ii]].label] = ii;
	}

/*  for (std::map<int, int>::iterator it = m_label2idx.begin(); it != m_label2idx.end(); it++)
			std::cout << (*it).first << "\t" << (*it).second << std::endl;
*/
/*  sort(m_vars_labels.begin(), m_vars_labels.end());

  for (uint var = 0; var < m_vars_labels.size(); var++)
    std::cout << m_vars_labels[var] << " ";
  std::cout << std::endl;*/
}

//void FGraph::readExact(const char *filename)
//{
//	// first log Z
//  std::ifstream infile(filename);
//	std::string s;
//	std::stringstream s1(s);
//	double Z;
//	s1 >> Z;
//	m_logZ_exact = log(Z);
//
//	// then marginals
//  while (1) {
//		int label;
//	  Real p0, p1;
//	  getline(infile, s);
//	  std::stringstream s1(s);
//	  if (s1 >> label) {
//		  s1 >> p0;
//		  s1 >> p1;
//		  VProb p; p.push_back(p0); p.push_back(p1);
//		  setExactMarginal( m_label2idx[label], p );
//		  std::cout << label << " " << p << std::endl;
//   	} 
//		else break;
//  } 
//  infile.close();
//  m_exact = true;
//}

void FGraph::exact() {

  uint q = 2, total_vals = 1;
  PIndex jidx;
  for (uint vv = 0; vv < m_nvars; vv ++) {
    total_vals *= q;
    jidx.addVar(q);
  }

  // compute joint by brute-force
  VProb joint(total_vals, 1.);
  VProb joint_log(total_vals, 0.);
  std::vector<bool> sign(total_vals, true);
  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {

    // get the factor
    VProb factor = (*g)[*f].psi;
    PIndex idxf = (*g)[*f].index;

    if (degree(*f, *g) == 1) {
			AdjIt ab, ae;
      tie(ab, ae) = adjacent_vertices(*f, *g);
      uint pos_var = m_vars_pos[*ab]; //(*g)[*ab].label-1;
      for (uint i = 0; i < total_vals; i++) {
				joint[i] *= factor[jidx[i][pos_var]];
				joint_log[i] += logl(fabsl(factor[jidx[i][pos_var]]));
				if (factor[jidx[i][pos_var]] < 0)
					sign[i] = !sign[i];
      }
    }
    else if (degree(*f, *g) == 2) {
 
      AdjIt ab, ae;
      tie(ab, ae) = adjacent_vertices(*f, *g);
      uint pos_var1 = m_vars_pos[*ab]; //(*g)[*ab].label-1;
      ab++;
      uint pos_var2 = m_vars_pos[*ab]; //(*g)[*ab].label-1;
      if (pos_var1 > pos_var2) {
				throw "Unexpected error computing FGraph::exact";
			}

//      cout << "vars " << pos_var1 << " " << pos_var2 << endl;
      VectorInt midx = jidx.getIndex2(pos_var1, pos_var2);
//      for (int iu = 0; iu < midx.size(); iu++) cout << midx[iu] << " "; cout << endl;
      
      for (uint i = 0; i < total_vals; i++) {
				joint[i] *= factor[midx[i]];
				joint_log[i] += logl(fabsl(factor[midx[i]]));
				if (factor[midx[i]] < 0) sign[i] = !sign[i];
      }
    }
    else {
      throw "EXACT only supports pairwise interactions (sorry)... Use libDAI";
    }
  }

	m_logZ_exact = logl(joint.normalizeL1());

	std::cout << "m_logZ_exact = " << m_logZ_exact << std::endl;

  // single node exact marginals
  std::vector<VProb> probs;
  for (uint i=0; i<m_nvars; i++) {
    VProb p(2,0.);
    for (uint j = 0; j < total_vals; j++) {
      p[jidx[j][i]] += joint[j];
    }
    probs.push_back(p);
    std::cout << "p[" << i << "] = " << p << " m = " << p[0] - p[1] << std::endl;
  }

  // pairwise exact marginals
  std::vector<std::vector<VProb> > prob2;
  for (uint i=0; i<m_nvars; i++) {
    std::vector<VProb> prob2i;
    for (uint j=i; j<m_nvars; j++) {
      VProb p2(q*q, 0.);
      VectorInt midx = jidx.getIndex2(i, j);
      for (uint k = 0; k < total_vals; k++) {
				p2[midx[k]] += joint[k];
      }
      //      std::cout << "p2[" << i << "," << j << "] = " << p2 << std::endl;
      prob2i.push_back(p2);
    }
    prob2.push_back(prob2i);
  }

  // exact covariances
  std::vector<std::vector<VProb> > covs;
  for (uint i = 0; i < m_nvars; i++) {
    std::vector<VProb> covi;
    for (uint j = i; j < m_nvars; j++) {
      VProb scov(q*q, 0.);
      for (uint k = 0, l = 0; k < q*q; k++) {
				if (k && (k%2 == 0)) l++;
				scov[k] = prob2[i][j-i][k] - probs[i][k%2]*probs[j][l];
      }
      //std::cout << "cov[" << i << "," << j << "] = " << scov << std::endl;
      covi.push_back(scov);
    }
    covs.push_back(covi);
  }

  // insert probabilities and covariances in the graph
  uint i = 0;
  for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++){

    //    std::cout << (*g)[*itv].label << std::endl;
    (*g)[*itv].p = probs[i];
    for (uint j = 0; j < m_nvars; j++) {
      uint x = (i<j) ? i : j;
      uint y = (i>j) ? i : j;
      //      std::cout << "\t" << i << "," << j << " " << x << "," << y << std::endl;

      (*g)[*itv].m_cov.push_back(covs[x][y-x]);
    }
    i++;
  }
	std::cout << "EXACT]" << std::endl;
  m_method = EXACT1;
	m_exact = true;
}

VProb FGraph::getCov(int vari, int varj)
{
  // get the varj position of the m_cov of vari node
  // note that g is indexed by Vertex (obtained using m_vars_labels)
  // and m_cov is indexed by an index
  return (*g)[m_vars_labels[vari]].m_cov[varj];
}

FGraph::~FGraph()
{
  // delete random seed
  //gsl_rng_free(m_r);

  // delete boost graph
  delete g;
}

// variable -> factor
VProb FGraph::getBPn(const Edge& e, bool old)
{
  OutEdgeIt b_begin, b_end;
  Vertex a = source(e, (*g));       // factor a
  Vertex i = target(e, (*g));       // variable i
  VProb n_msg((*g)[i].size,1.);

  // for each neighbor b of the variable j except a
  for (tie(b_begin, b_end) = out_edges(i, (*g)); b_begin != b_end; b_begin++) {
    Vertex b = target(*b_begin, (*g));  // the factor b
    if (b != a)
      n_msg *= (old) ? (*g)[*b_begin].m_old : (*g)[*b_begin].m_new;
  }

//  if (m_negpot)
//		n_msg.normalizeLInf();
//	else
//		n_msg.normalizeL1();

  return n_msg;
}

// factor -> variable
VProb FGraph::getBPm(const Edge& e, bool old)
{
  // declare variables outside the loops for efficiency
  OutEdgeIt j_begin, j_end;
  Vertex a = source(e, (*g));       // factor a
  Vertex i = target(e, (*g));       // variable i
  Vertex j;
  VProb nmsg;

  // temporal factor with the values of the potential and its index
  VProb factor((*g)[a].psi), prob;
  PIndex *index = &(*g)[a].index;

  // for each neighbor j of the factor a except i
  for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++) {

    j = target(*j_begin, (*g));  // the variable j
    if (j != i) {

      // iterate over all factor values indexing the n msg
      nmsg = getBPn(*j_begin, old);
      for (uint itf=0; itf<factor.size(); itf++)
        factor[itf] *= nmsg[index->get(itf,(*g)[*j_begin].pos_index)];
    }
  }

  // SUM STEP : marginalize to obtain the message
  prob.reset((*g)[i].size, 0.);
  for (uint itf = 0; itf < factor.size(); itf++)
    prob[index->get(itf, (*g)[e].pos_index)] += factor[itf];

  // normalize m messages
//  #ifdef NORM_BP
	if (m_negpot)
		prob.normalizeLInf();//NORM_BP);
	else
		prob.normalizeL1();//NORM_BP);
//  #endif

//	if ( (*g)[i].label == 6345) { 

//		std::cout << "Mmesg from "<<  a <<" is "<< prob;
//		std::cout << " size " << a << " is " << factor.size() << std::endl;
//  } 

  return prob;
}

bool FGraph::doBP(Real tol, uint max_iter, int verb, bool output)
{
  m_tol = tol;
  m_max_iter = max_iter;
	m_output = output;

  clock_t init_clock, end_clock;
  init_clock = ttoc();

  // Initializations
  EdgeIt ei, ei_end;
  VProb msg;
  switch (m_bp_variant) {

  case BP_MAXRES:

    // do the first pass
    for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei)
      (*g)[*ei].m_new = getBPm(*ei, true);

    // Initialize the residuals in a first iteration
    for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {
      VProb msg = getBPm(*ei, true);
      Real residual = msg.mdiff((*g)[*ei].m_old);
      (*g)[*ei].it_residual = m_map_res.insert(MapResElem(residual, *ei));
    }
    break;

  case BP_SEQRND:

    // Initialize the random vector of edges
    for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei)
      m_rnd_edges.push_back(*ei);
    break;

  default:
    break;
  }

  // Main loop
  OutEdgeIt b_begin, b_end, j_begin, j_end;
  Vertex a, i, j, b;
  uint step = 0;
  bool convergence = false;
  while ( (!convergence) && (step < max_iter) ) {

    step++;
    m_maxdif = -1.;
    switch (m_bp_variant) {

    case BP_MAXRES:

      for (uint ed = 0; ed < m_nedges; ed++) {
				
				// Koller et al
				// select the edge with highest residual O(1)
				MapResIt it_map = m_map_res.end();
				it_map--;
				Edge edge_maxr = (*it_map).second;

        //for (MapResIt it_map2 = m_map_res.begin(); it_map2 != m_map_res.end(); it_map2++) {
        //  std::cout << setprecision(5) << (*it_map2).first << " ";
        //}
        //std::cout << std::endl;

        // get new msg and replace the residual with 0
       	//	(*g)[edge_maxr].n_new = getBPn(edge_maxr);

        // this is just to reproduce Joris output...
				bool use_old = (!step) ? true : false;
				(*g)[edge_maxr].m_new = getBPm(edge_maxr, use_old);

				//std::cout << "ma" << (*g)[edge_maxr].m_new << std::endl;
				m_map_res.erase((*g)[edge_maxr].it_residual);
				(*g)[edge_maxr].it_residual = m_map_res.insert(MapResElem( 0., edge_maxr ));

				// update the affected messages
				a = source(edge_maxr, (*g));
				i = target(edge_maxr, (*g));
	
				for (tie(b_begin, b_end) = out_edges(i, (*g)); b_begin != b_end; b_begin++) {
					b = target(*b_begin, (*g));
					if (b != a) {
						for (tie(j_begin, j_end) = out_edges(b, (*g)); j_begin != j_end; j_begin++) {
							j = target(*j_begin, (*g));
							if (j != i) {
								VProb hip_msg = getBPm(*j_begin, false);
								m_map_res.erase((*g)[*j_begin].it_residual);
								Real residual = hip_msg.mdiff((*g)[*j_begin].m_new);
								//std::cout << "\t\t hip msg " << hip_msg << " new residual! " << residual << std::endl;
								(*g)[*j_begin].it_residual = m_map_res.insert(MapResElem( residual, *j_begin ));
							}
						}
					}
				}
      }
      break;

    case BP_SEQRND:

      // shuffle the ordering of the edges
      random_shuffle( m_rnd_edges.begin(), m_rnd_edges.end() );
      for (std::vector<Edge>::iterator it = m_rnd_edges.begin(); it != m_rnd_edges.end(); it++) {
        // (*g)[*it].n_new = getBPn(*it, false);
        (*g)[*it].m_new = getBPm(*it, false);
      }
      break;

    case BP_PARAL:

      // set the new msgs of each edge
      for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei)
				(*g)[*ei].m_new = getBPm(*ei, true);

      // replace the old with new msgs
      for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei)
				(*g)[*ei].m_old = (*g)[*ei].m_new;

      break;

    default:

      for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {
				//	(*g)[*ei].n_new = getBPn(*ei);
				(*g)[*ei].m_new = getBPm(*ei, false);
      }
      break;
    }

    // get the beliefs
    OutEdgeIt out_b, out_e;
    for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {
      Vertex v = *itv;
      VProb bel((*g)[v].size, 1.);
      
      // compute beliefs for each edge to the var v
      for (tie(out_b, out_e) = out_edges(v, *g); out_b != out_e; out_b++) {
        bel *= (*g)[*out_b].m_new;
      }

      // normalize 
//      if (m_negpot)
//				bel.normalizeLInf();
//			else
				bel.normalizeL1();					

			// compute differences with previous iteration and update the maximum
      Real bel_dif = (*g)[v].bel.mdiff(bel);
      m_maxdif = (bel_dif > m_maxdif) ? bel_dif : m_maxdif;

      // set the belief
      (*g)[v].bel = bel;
    }

    convergence = (m_maxdif < m_tol);
    if (verb > 2) {
      std::cout << step << " -BP--------------------------- " << m_maxdif << std::endl;
    }
  }

  if (convergence && (verb >= 1)) {
    std::cout << "BP converged after " << step << " iterations using " << getBPVariantString();
    cout << " maxdiff = " << setprecision(15) << m_maxdif << std::endl;
  }

	m_BP_steps = step;
  end_clock = ttoc();
  m_cpu_bp = end_clock - init_clock;

	// output number of iterations and cpu-time
	if ( m_output ) {
		std::ofstream fstats;
		char sfbel[100];
		sprintf(sfbel, "%s.stats", m_filename.substr(m_filename.find_last_of('/')+1, m_filename.size()-m_filename.find_last_of('/')).c_str());
		std::cout << "Opening file " << sfbel << " for writing" << std::endl;
		fstats.open(sfbel, ios::app);
		if (!fstats.good())
			throw "... cannot open the file " + std::string(sfbel);
		fstats << step << "\t" << toSeconds(m_cpu_bp) << "\t" << m_cpu_bp << std::endl;
		fstats.close();
	}
 
  // compute last n msgs if required
//  if ( (m_bp_variant == BP_MAXRES) || (m_bp_variant == BP_PARAL) )
  for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {
    (*g)[*ei].n_new = getBPn(*ei, false);
  }

  for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {
//    std::cout << *ei << std::endl;
//    std::cout << "\tn = " << (*g)[*ei].n_new[0] << " " << (*g)[*ei].n_new[1] << std::endl;
//    std::cout << "\tm = " << (*g)[*ei].m_new[0] << " " << (*g)[*ei].m_new[1] << std::endl;
  }
//  graph2Dot("satBP.dot");

  std::vector<Real> ms;
  if (convergence && (verb > 1)) { std::cout << "bp beliefs:" << std::endl; }

  int nmone = 0;

	// output beliefs
  std::ofstream fbel;
	if ( m_output ) {
	char sfbel[100];
  sprintf(sfbel, "%s.bel", m_filename.substr(m_filename.find_last_of('/')+1, m_filename.size()-m_filename.find_last_of('/')).c_str());
	std::cout << "Opening file " << sfbel << " for writing" << std::endl;
  fbel.open(sfbel);
		if (!fbel.good())
			throw "... cannot open the file " + std::string(sfbel);
	}

	double bmax = 0.; Vertex vmax = -1;
	for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {

    if (convergence && (verb > 1)) {
			std::cout << "["<< (*g)[*itv].bel[0] << " " << (*g)[*itv].bel[1] << std::endl;
    }
    (*g)[*itv].m = (*g)[*itv].bel[0]-(*g)[*itv].bel[1];

    // warn about those beliefs with extreme values (less than machine precission)
    Real thresh = 1e-14;
    if ( ( ((*g)[*itv].bel[0] < thresh) || ((*g)[*itv].bel[1] < thresh) ) && verb ) {
      std::cout << "\t\t\t\t\tBELIEFS CLOSE TO 1!!!" << std::endl;
      nmone++;
    }

		// output beliefs of non-dummy vars to a file
  	if ( m_output  ) {
			if ((*g)[*itv].bel[1] > bmax) { bmax = (*g)[*itv].bel[1]; vmax = *itv; }
	    fbel << (*g)[*itv].label << "\t" << setprecision(14) << (*g)[*itv].bel[0] << "\t" << (*g)[*itv].bel[1] << std::endl;
		}
  }

	if ( m_output ) fbel.close();

	// compute pairwise marginals
  if (convergence && (verb > 1)) std::cout << "bp (factor) beliefs:" << endl;
  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {

    Vertex a = *f;
    VProb bel = (*g)[a].psi;
    PIndex *index = &(*g)[a].index;

    // multiply the factor with the n messages
    for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++)
      for (uint itf = 0; itf < bel.size(); itf++)
				bel[itf] *= (*g)[*j_begin].n_new[index->get(itf,(*g)[*j_begin].pos_index)];

		if (m_negpot)
			bel.normalizeLInf();
		else
			bel.normalizeL1();

//		if (convergence && (verb > 1)) { cout << bel << std::endl; }
 
    // set the belief to the factor node
    (*g)[a].bel = bel;

    // bel is the marginal of the vars within the factor
    // marginalize over all pairs in the factor
    OutEdgeIt j1_begin, j1_end, j2_begin, j2_end;
    for (tie(j1_begin, j1_end) = out_edges(a, (*g)); j1_begin != j1_end; j1_begin++) {

      Vertex j1 = target(*j1_begin, (*g));

      // check single node marginals
      VProb sm((*g)[j1].size,0.);
      for (uint itf = 0; itf < bel.size(); itf++)
        sm[index->get(itf,(*g)[*j1_begin].pos_index)] += bel[itf];

			for (tie(j2_begin, j2_end) = out_edges(a, (*g)); j2_begin != j2_end; j2_begin++) {
        Vertex j2 = target(*j2_begin, (*g));
        if (j2 >= j1) {
          VProb marg((*g)[j1].size*(*g)[j2].size,0.);
          int var1 = (*g)[*j1_begin].pos_index;
          int var2 = (*g)[*j2_begin].pos_index;
          VectorInt index2 = index->getIndex2(var1, var2);
          for (uint itf = 0; itf < bel.size(); itf++)
            marg[index2[itf]] += bel[itf];

//  	  Real chi = marg[0] - marg[1] - marg[2] + marg[3];
        }
      }
    } // end pairwise marginals
  } // end factors

  
  // Bethe free energy to get the Z
  Real Ubethe = 0., Hbethe = 0.;
  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {
    VProb *factor = &((*g)[*f].psi), *bel = &((*g)[*f].bel);
    for (uint i = 0; i < (*factor).size(); i++) {
			if ( ((*factor)[i]<0) || ((*bel)[i]<0) ) {
	 	    std::cout << "negative beliefs " << (*factor)[i] << " " << (*bel)[i] << std::endl;
			} else {
        if (((*factor)[i]) && (*bel)[i]) {
          Ubethe += (*bel)[i] * logl((*factor)[i]);
          Hbethe += (*bel)[i] * logl((*bel)[i]);//if (degree(*f, *g)>1)

					if ( isnan(Ubethe) || isnan(Hbethe) ) {
						std::cout << *f << " " << (*factor)[i] << " " << (*bel)[i] << std::endl;
						throw "isnan";
					}
        }
      }
    }
  }
  Hbethe = -Hbethe;
  for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {
    VProb *bel = &((*g)[*itv].bel);
    Real h;
//    if ( (!(*bel)[0]) || (!(*bel)[1]) || ((*bel)[0]<0) || ((*bel)[1]<0) ) h = 0.;
    if ( ((*bel)[0]>0) && ((*bel)[1]>0) )
			h = ( (*bel)[0] * logl((*bel)[0]) ) + ( (*bel)[1] * logl((*bel)[1]) );    // only binary....
		else
			h = 0;
    Hbethe += (degree(*itv, *g)-1)*h;
		if (isnan(Hbethe)) throw "isnan";
  }
  if (verb > 1) {
		std::cout << "U = " << Ubethe << std::endl;
	  std::cout << "S = " << Hbethe << std::endl;
	}

  m_logZ_bp = (Ubethe + Hbethe);

  return true;
}

VProb FGraph::getLRN(const Edge& e, const Vertex &k, const bool norm, int verb)
{
  OutEdgeIt b_begin, b_end;
  Vertex a = source(e, (*g));       // factor a
  Vertex j = target(e, (*g));       // variable j
  int qk = (*g)[k].size;
  int qj = (*g)[j].size;
  VProb N_msg((*g)[j].size * qk, 0);

  bool deb = false;

  // for each neighbor b of the variable j except a
  for (tie(b_begin, b_end) = out_edges(j, (*g)); b_begin != b_end; b_begin++) {

    Vertex b = target(*b_begin, (*g));  // the factor b
    if (b != a) {
      if (deb) std::cout << "\t\tThe M message from " << b << " " << (*g)[*b_begin].M << std::endl;
      N_msg += (*g)[*b_begin].M;
    }
  }

  // sum 1 in the diagonal if same variable
  if (k == j) {
    if (deb) std::cout << "\t\tsumming diag" << std::endl;
    for (int xj = 0; xj < qk; xj++) {
      N_msg[qk*xj+xj] += 1.;
    }
  }

  if (norm) {

    // normalize
    if (deb) std::cout << "\t\tN sum = " << N_msg << std::endl;
    VProb knorm(qk, 0.);
    VProb n0 = (*g)[e].n_new;
    for (uint xj = 0, yk = 0; xj < N_msg.size(); xj++) {
      if (xj && (xj%qj == 0)) yk++;
      knorm[yk] += n0[xj%qj] * N_msg[xj];
    }
    if (deb) std::cout << "\t\tN normalization sum = " << knorm << std::endl;
    for (uint xj = 0, yk = 0; xj < N_msg.size(); xj++) {
      if (xj && (xj%qj == 0)) yk++;

      // normalization
      N_msg[xj] -= knorm[yk];
    }
    if (deb) std::cout << "\t\tN final " << a << " " << j << " = " << N_msg << std::endl;

    VProb kmsg(qk, 0.);
    for (uint xj = 0, yk = 0; xj < N_msg.size(); xj++) {
      if (xj && (xj%qj == 0)) yk++;
      kmsg[yk] += N_msg[xj];
    }

    // some checks...
    if ((kmsg[0] + kmsg[1]) > 1e-12) {
      if (verb==2) std::cout << "N > 0 ! " << kmsg << " sum " << kmsg[0] + kmsg[1] << " ";
      Real err = fabsl(N_msg[2]+N_msg[0])+fabsl(N_msg[3]+N_msg[1]);
      N_msg[2] = -N_msg[0]; N_msg[3] = -N_msg[1];
      if (verb==2) std::cout << "err = " << fabsl(N_msg[2]+N_msg[0]) << " + " << fabsl(N_msg[3]+N_msg[1]) << " = " << err << std::endl;

      // check again ...
      VProb kmsg(qk, 0.);
      for (uint xj = 0, yk = 0; xj < N_msg.size(); xj++) {
        if (xj && (xj%qj == 0)) yk++;
        kmsg[yk] += N_msg[xj];
      }
      if ((kmsg[0] + kmsg[1]) > 1e-12) {
        if (verb==2) std::cout << "\tN > 0 ! " << kmsg << " sum " << kmsg[0] + kmsg[1] << " ";
      }
    }
  }
  return N_msg;
}

VProb FGraph::getLRM(const Edge& e, const Vertex &k, int verb)
{
  OutEdgeIt j_begin, j_end;
  Vertex a = source(e, (*g));       // factor a
  Vertex i = target(e, (*g));       // variable i
  Vertex j;
  VProb factor((*g)[e].F);
  int qk = (*g)[k].size;
  VectorInt *indexM;

  bool deb = false;
  VProb M_msg((*g)[i].size * qk, 0.);

  if (deb) std::cout << "From " << a << " to " << i << " " << (*g)[e].M << std::endl;

  // for each neighbor j of the factor a except i
  if (degree(a, *g) > 1) {

    VProb prob_sum((*g)[e].F.size(), 0.);
    for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++) {
      
      j = target(*j_begin, (*g));  // the variable j
      if (j != i) {
	//	(*g)[*j_begin].N = getLRN(*j_begin, k);       //N_msg;
	if (deb) std::cout << "\tthe N message from = " << *j_begin << (*g)[*j_begin].N << std::endl;

	// sum the N messages
	indexM = &(*g)[*j_begin].indexM;
	for (uint itf = 0; itf < factor.size(); itf++)
	  prob_sum[itf] += (*g)[*j_begin].N[(*indexM)[itf]];
	if (deb) std::cout << "\tafter sum the N message = " << *j_begin << prob_sum << std::endl;
      }
    }
    // multiply only in the case that neighbours exist
    factor *= prob_sum;
    if (deb) std::cout << "\tafter product of the N messages = " << factor << std::endl;
  }

  // SUM STEP : marginalize to obtain the message
  indexM = &(*g)[e].indexM;
  for (uint itf = 0; itf < factor.size(); itf++)
    M_msg[(*indexM)[itf]] += factor[itf];

//  std::cout << "\tM = " << M_msg << std::endl;
//	char caa;
//	std::cin >> caa;

  // normalization of the M messages
/*  VProb knorm(qk, 0.);
  VProb m0 = (*g)[e].m_new;
  for (uint xi = 0, yk = 0; xi < M_msg.size(); xi++) {
    if (xi && (xi%qi == 0)) yk++;
    knorm[yk] += m0[xi%qi] * M_msg[xi];
  }
  if (deb) std::cout << "\t\tM normalization sum = " << knorm << std::endl;
  for (uint xi = 0, yk = 0; xi < M_msg.size(); xi++) {
    if (xi && (xi%qi == 0)) yk++;
    M_msg[xi] -= knorm[yk];
  }
  if (deb) std::cout << "\t\tM final " <<  i << " " << a << " = " << M_msg << std::endl;

  VProb kmsg(qk, 0.);
  for (uint xi = 0, yk = 0; xi < M_msg.size(); xi++) {
    if (xi && (xi%qi == 0)) yk++;
    kmsg[yk] += M_msg[xi];
  }
  if ((kmsg[0] + kmsg[1]) > 1e-11) {
    std::cout << "M > 0 ! " << kmsg << " sum " << kmsg[0] + kmsg[1] << " ";
    Real err = fabsl(M_msg[2]+M_msg[0])+fabsl(M_msg[3]+M_msg[1]);
    M_msg[2] = -M_msg[0]; M_msg[3] = -M_msg[1];
    std::cout << "err = " << fabsl(M_msg[2]+M_msg[0]) << " + " << fabsl(M_msg[3]+M_msg[1]) << " = " << err << std::endl;    
  }*/
  return M_msg;
}

bool FGraph::doLR(Real tol, uint max_iter, int verb)
{
  m_tol = tol;

  std::cout << "Starting LR..." << std::endl;

	// create the F term for all the factors
  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {

    Vertex a = *f;     // factor a

    // create F using the factor
    VProb F((*g)[a].psi.size(), 0.);

    // add the F for each neighbor j of the factor a
    OutEdgeIt j_begin, j_end;
    for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++)
      (*g)[*j_begin].F = F;
  }

  // compute the F term forall edges 
  EdgeIt ei, ei_end;
  for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {

		/*    std::cout << *ei << std::endl;
    std::cout << "\t" << (*g)[*ei].m_new << std::endl;
    std::cout << "\t" << (*g)[*ei].n_new << std::endl;*/

    PIndex *index = &(*g)[source(*ei, (*g))].index; // index of F
    Vertex i = target(*ei, (*g));                   // variable i
    Vertex a = source(*ei, (*g));                   // factor a

    // print F, m and n's
    if (verb > 1) {
      std::cout << std::endl << "-LR------------------------- FACTOR " << a << std::endl;
      std::cout << "phi = " << (*g)[a].psi << std::endl;
      std::cout << "m" << *ei << " = " << (*g)[*ei].m_new << std::endl;
      OutEdgeIt j_begin, j_end;
      for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++) {
				Vertex j = target(*j_begin, (*g));  // the variable j
				if (j != i)
					std::cout << "n" << *j_begin << " = " << (*g)[*j_begin].n_new << std::endl;
      }
    }

    // compute the F value: forall factor values
    for (uint itf=0; itf<(*g)[*ei].F.size(); itf++) {
      
      // the m_{ai} component (TEST div 0)
      if ((*g)[*ei].m_new[index->get(itf, (*g)[*ei].pos_index)] == 0.) {
				(*g)[*ei].F[itf] = 0.;
				std::cout << "DIV by zero" << std::endl; 
      }
      else
				(*g)[*ei].F[itf] = (*g)[a].psi[itf]/(*g)[*ei].m_new[index->get(itf, (*g)[*ei].pos_index)];
      
      // the n_{ja} component
      OutEdgeIt j_begin, j_end;
      for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++) {
				Vertex j = target(*j_begin, (*g));  // the variable j
				if (j != i) {
					PEdge *vj = &(*g)[*j_begin];
					(*g)[*ei].F[itf] *= vj->n_new[index->get(itf,vj->pos_index)];
				}
      }
    }
    if (verb > 1) std::cout << "\tF" << *ei << " " << (*g)[*ei].F << std::endl;
  }

  // forall variable k
  int qk = 0, var = 0;
  m_cpu_lr = 0;
  m_map_LR_vars.clear();

  // for each variable in increasing size (we also increase the var counter for m_map_LR_vars...)
  for (VectorVertexIt ik = m_vars_sizes.begin(); ik != m_vars_sizes.end(); ik++, var++) {

    clock_t init_clock, end_clock;
    init_clock = ttoc();

    Vertex k = *ik;

    // add the variable-position into the map
    m_map_LR_vars[k] = var;

    // add y_k to the F terms and the indices if necessary (because it has more values...)
    if ((*g)[k].size != qk) {

      qk = (*g)[k].size;
      for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {
				Vertex a = *f;     // factor a

				// add the F for each neighbor j of the factor a
				OutEdgeIt j_begin, j_end;
				for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++) {

					// expand the table with as many entries as qk-1
					for (int i = 0; i < (qk-1); i++)
						(*g)[*j_begin].F.insert((*g)[*j_begin].F.begin(), (*g)[*j_begin].F.begin(), (*g)[*j_begin].F.end());
				}


				// add the required indices to F in the factor node
				// TODO : change addVar to remove/addVar. does not work for non-binary variables...

				(*g)[a].index.addVar(qk);
 
				// add the required indices for marginalization
				for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++) {
					(*g)[*j_begin].indexM = (*g)[a].index.getIndexM((*g)[*j_begin].pos_index);
        }
      }
    }

    // initialize the N and M messages to zero
    for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {
      (*g)[*ei].N.reset((*g)[target(*ei, (*g))].size * qk, 0.);
      (*g)[*ei].M.reset((*g)[target(*ei, (*g))].size * qk, 0.);
    }

    // MAIN LOOP
    uint step = 0;
    bool convergence = false;
    VProb oldM, oldN;
    Real prev_diff = 1000;
    Edge emax;
    while ( (!convergence) && (step < max_iter) ) {

      m_maxdif = -1.;

      for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {
				oldM = (*g)[*ei].M;
				oldN = (*g)[*ei].N;
				(*g)[*ei].N = getLRN(*ei, k, true);
				(*g)[*ei].M = getLRM(*ei, k);
				if (verb > 2) {
          std::cout << "N " << *ei << "=" << (*g)[*ei].N << std::endl;
          std::cout << "M " << *ei << "=" << (*g)[*ei].M << std::endl;
        }
				Real diffM = (*g)[*ei].M.mdiff(oldM), diffN = (*g)[*ei].N.mdiff(oldN);
				if (diffM > m_maxdif) {
					m_maxdif = diffM;
					emax = *ei;
				}
				else if (diffN > m_maxdif) {
					m_maxdif = diffN;
					emax = *ei;
				}
      }
      convergence = (m_maxdif < m_tol);
      prev_diff = m_maxdif;
      step++;
			if (verb > 2)
				std::cout << step << " -LR-------------------------- " << m_maxdif << " " << emax << std::endl;

      //if (step == 10) return false;
      if (m_maxdif > 1e10) {
				std::cout << "LR explodes at iteration " << step << " with fgraph " << m_filename << std::endl;
				m_LR_steps = 0;
				return false;
      }
    }

    end_clock = ttoc();
    m_cpu_lr += (end_clock - init_clock);
  
    if (convergence) {
      m_LR_steps = step;
      std::cout << (*g)[k].label << "/" << m_nvars << " convergence after " << step << " LR iterations" << std::endl;
    }
    else {
      std::cout << "no convergence after " << step << " LR iterations... " << std::endl;
      return false;
    }

    // compute the Response matrices R and the correlations
    for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {
      Vertex i = *itv;

      // get the belief from BP
      VProb *bel = &(*g)[i].bel;
      int qi = (*g)[i].size;

      // for each factor neighbor sum the messages M
      VProb R(qi*qk,0.);
      OutEdgeIt b_begin, b_end;
      for (tie(b_begin, b_end) = out_edges(i, (*g)); b_begin != b_end; b_begin++)
				R += (*g)[*b_begin].M;

      // sum 1 in the diagonal if same variable
      if (k == i)
				for (int xi = 0; xi < qk; xi++)
					R[qk*xi+xi] += 1.;

      // normalize the R matrix
      VProb R2 = R;
      VProb sumxi2(qk);
      for (uint xi=0, yk=0; xi<R2.size(); xi++) {
        if (xi && (xi%qi == 0)) yk++;
        sumxi2[yk] += (*bel)[xi%qi]*R2[xi];
      }
      for (uint xi=0, yk=0; xi<R2.size(); xi++) {
        if (xi && (xi%qi == 0)) yk++;
        R2[xi] -= sumxi2[yk];
      }

      // until here we have the normalized Response matrix
      (*g)[i].m_R.push_back(R2);

      for (uint xi=0; xi<R2.size(); xi++)
        R2[xi] *= (*bel)[xi%qi];

      // a check...
      if ( (R2[0]+R2[1])>1e-14 || (R2[2]+R2[3])>1e-14 || R2[0]+R2[2]>1e-14 || R2[1]+R2[3]>1e-14)
				cout << "Error COVARIANCES!" << endl;
      (*g)[i].m_cov.push_back(R2);

			cout << "cov[" << (*g)[i].label << "," << (*g)[k].label << "]=" << R2 << endl;

      ///////////////////////////
      // Alternative method: compute covariances directly but does not keep R
/*      VProb sumxi(qk);
      for (uint xi=0, yk=0; xi<R.size(); xi++) {
	if (xi && (xi%qi == 0)) yk++;
	R[xi] *= (*bel)[xi%qi];
	sumxi[yk] += R[xi];
      }
      for (uint xi=0, yk=0; xi<R.size(); xi++) {
	if (xi && (xi%qi == 0)) yk++;
	R[xi] -= (*bel)[xi%qi] * sumxi[yk];
      }
      (*g)[i].m_cov.push_back(R);
      if ( (R[0]+R[1])>1e-14 || (R[2]+R[3])>1e-14 || R[0]+R[2]>1e-14 || R[1]+R[3]>1e-14) cout << "Error COVARIANCES!" << endl;
*/     

      // add p(xi)p(xj) to obtain the joint marginal
      VProb bLR(R);
      for (uint xi=0, yk=0; xi<R.size(); xi++) {
				if (xi && (xi%qi == 0)) yk++;
				bLR[xi] += (*bel)[xi%qi] * (*g)[k].bel[yk];
      }
    } // end covariances between vars i,k

    // Response matrix for factors
    for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {
      Vertex a = *f;                 // factor a
      VProb *bel = &(*g)[a].bel;
      int qa = (*g)[a].bel.size();

      // for each var neighbor sum the messages N 
      VProb R(qa*qk,0.);
      OutEdgeIt j_begin, j_end;
      for (tie(j_begin, j_end) = out_edges(a, (*g)); j_begin != j_end; j_begin++) {
        VProb N0 = getLRN(*j_begin, k, false);
				VectorInt *indexM = &(*g)[*j_begin].indexM;
				for (uint itf = 0; itf < R.size(); itf++)
					R[itf] += N0[(*indexM)[itf]];
			}
//cout << R << endl;
      (*g)[a].m_R.push_back(R);

      // normalize R for factor
      VProb R2 = R;
      VProb sumxa2(qk);
      for (uint xa=0, yk=0; xa<R2.size(); xa++) {
        if (xa && (xa%qa == 0)) yk++;
        sumxa2[yk] += (*bel)[xa%qa]*R2[xa];
      }
      for (uint xa=0, yk=0; xa<R2.size(); xa++) {
        if (xa && (xa%qa == 0)) yk++;
        R2[xa] -= sumxa2[yk];
      }

      // until here we have the normalized Response matrix
      (*g)[a].m_R.push_back(R2);

      for (uint xa=0; xa<R2.size(); xa++)
				R2[xa] *= (*bel)[xa%qa];
      (*g)[a].m_cov.push_back(R2);

    } // end Response matrix between factor a and var k

  } // end forall variable k

/*
  std::cout << "R factors" << std::endl;
  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {
    Vertex a = *f;     // factor a
    std::cout << "R_" << a << std::endl;
    for (VectorVProbIt itc = (*g)[a].m_R.begin(); itc != (*g)[a].m_R.end(); itc++) {
      std::cout << setprecision(3) << (*itc) << std::endl;
    }
    std::cout << std::endl;
  }  
  std::cout << "end R factors" << std::endl;
  // Response matrix for variables
  std::cout << "R vars" << std::endl;
  for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {
    Vertex i = *itv;
    std::cout << "R_" << i << std::endl;
    for (VectorVProbIt itc = (*g)[i].m_R.begin(); itc != (*g)[i].m_R.end(); itc++) {
      std::cout << setprecision(3) << (*itc) << std::endl;
    }
    std::cout << std::endl;
  }  
  std::cout << "end R vars" << std::endl;
*/

  m_method = BPLR;
  return true;
}

void FGraph::writeCov() {

  std::string str_var;
  switch (m_method) {
  case EXACT1: str_var = "EXACT.out"; break;
  case COND: str_var = "COND.out"; break;
  case BPLR: str_var = "BPLR.out"; break;
  }
  m_filename_cov = m_filename + std::string(".cov.") + str_var;
  std::string fcov(m_filename_cov);

  std::ofstream out_cov(fcov.c_str());
  for (VectorVertexIt iti = m_vars_labels.begin(); iti != m_vars_labels.end(); iti++) {
    Vertex i = *iti;
    for (VectorVProbIt itc = (*g)[i].m_cov.begin(); itc != (*g)[i].m_cov.end(); itc++) {
      out_cov << (*itc) << std::endl;
    }
    out_cov << std::endl;
  }
}

std::map<Vertex, VProb> FGraph::clamp(int var, uint val)
{
  std::map<Vertex, VProb> map_factors;

  // while no integration with libAI lets search sequentially for the variable
/*
 * VectorVertexIt itv = m_vars_labels.begin();
  bool found = false;
  while ( !found && (itv != m_vars_labels.end()) ) {
    if ((*g)[*itv].label == var) found = true;
    else itv++;
  }

  if (!found) {
    std::cout << "Error: no var " << var << " found" << std::endl;
    return map_factors;
  }
  Vertex i = *itv;
*/
  Vertex i = m_vars_labels[var];

	std::cout << "clamping " << (*g)[m_vars_labels[var]].label << std::endl;
  // traverse all its factors
  OutEdgeIt b_begin, b_end;
  for (tie(b_begin, b_end) = out_edges(i, (*g)); b_begin != b_end; b_begin++) {
    Vertex b = target(*b_begin, (*g));  // the factor b
    if ( (*g)[b].type != FACTOR ) {
      std::cout << "Error! not a factor!" << std::endl;
      return map_factors;
    }

		VProb factor((*g)[b].psi);
    PIndex *index = &(*g)[b].index;
    map_factors[b] = factor;
    for (uint itf=0; itf<factor.size(); itf++) {
      if (val != index->get(itf,(*g)[*b_begin].pos_index))
        factor[itf] = 0;
    }
    (*g)[b].psi = factor;
  }

  // check clampings
/*  std::cout << "[new factors" << std::endl;
  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {
    std::cout << (*g)[*f].psi << std::endl;
  }
  std::cout << "new factors]" << std::endl;
*/
  return map_factors;
}

void FGraph::unclamp(int var, std::map<Vertex, VProb> factors)
{
  for (std::map<Vertex, VProb>::iterator it = factors.begin(); it != factors.end(); it++)
    (*g)[(*it).first].psi = (*it).second;

  // check unclampings
//  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {
//    std::cout << (*g)[*f].psi << std::endl;
//  }
}

bool FGraph::doCOND(Real tol, uint max_iter)
{
  // traverse the single node factors clamping the single node pots
  // THERE MUST BE A SINGLE NODE POTENTIAL PER VARIABLE IN THE GRAPH
  
  m_tol = tol;
  std::pair<VertexIt, VertexIt> iit, kit;
  uint var = 0;
  for (VectorVertexIt f = m_factors.begin(); f != m_factors.end(); f++) {

    // for all single node potentials (degree 1)
    Vertex a = *f;
    if (degree(a, *g) == 1) {

      uint qa = (*g)[a].psi.size();

      // create tables for conditional distributions
      // in each variable node
      for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {
				VProb cond((*g)[*itv].bel.size() * qa, 0.);
				(*g)[*itv].m_cond.push_back(cond);
      }

      OutEdgeIt ib, je; tie(ib, je) = out_edges(a, *g);
      VProb prob0((*g)[a].psi);
      for (uint val = 0; val < qa; val++) {
				
				// clamp the variable
				VProb prob_cond(qa, 0.);
				prob_cond[val] = 1.;
				(*g)[a].psi = prob_cond;

				///////////////////////////////
				// do BP to obtain conditionals
				if (!doBP(m_tol, max_iter)) {
					std::cout << "\tCOND has not converged" << std::endl;
					return false;
				}	

				// set one row of the conditionals
				for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {
					uint qi = (*g)[*itv].bel.size();
					for (uint vi = 0; vi < qi; vi++) {
						(*g)[*itv].m_cond[var][val*qi + vi] = (*g)[*itv].bel[vi];
					}
				}

				// reset the messages
				reset();
      }

      // set the potential to the original value
      (*g)[a].psi = prob0;
      var++;
    }
  }

  ///////////////////////////////
  // do BP without clamping
  if (!doBP(m_tol, max_iter)) {
    std::cout << "\tCOND has not converged" << std::endl;
    return false;
  }

	// compute the joints
  for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++) {

    // variable i
    Vertex i = *itv;
    uint qi = (*g)[i].bel.size();
    int y=0;

    for (VectorVertexIt itk = m_vars_labels.begin(); itk != m_vars_labels.end(); itk++) {

      // variable k
      Vertex k = *itk;
      uint qk = (*g)[k].bel.size();
      (*g)[i].m_joint.push_back(qi*qk);

      // joint pf between i and k
      for (uint xi = 0, yk = 0; xi < qi*qk; xi++) {
				if (xi && (xi%qi == 0)) yk++;
				(*g)[i].m_joint[y][xi] = (*g)[i].m_cond[y][xi] * (*g)[k].bel[yk];
      }
      y++;
    }
  }

  // compute the covariances
  // IMPORTANT : x,y are indices of variables in the same labeling order !!!

  std::vector<std::vector<VProb> > covs;
  int x = 0;
  for (VectorVertexIt iti = m_vars_labels.begin(); iti != m_vars_labels.end(); iti++) {

    // variable i
    Vertex i = *iti;
    uint qi = (*g)[i].bel.size();
    int y = 0;
    std::vector<VProb> covi;
    for (VectorVertexIt itk = m_vars_labels.begin(); itk != m_vars_labels.end(); itk++) {

      // variable k
      Vertex k = *itk;
      uint qk = (*g)[k].bel.size();

      // marginalize i in the joint i,k
      VProb margi(qi, 0.);
      for (uint xi = 0; xi < qi*qk; xi++)
				margi[xi%qi] += (*g)[i].m_joint[y][xi];

      // marginalize k in the joint k,i
      VProb margk(qk, 0.);
      for (uint yk = 0; yk < qi*qk; yk++)
				margk[yk%qk] += (*g)[k].m_joint[x][yk];

      VProb cov(qi*qk);
      for (uint xi = 0, yk = 0; xi < qi*qk; xi++) {
				if (xi && (xi%qi == 0)) yk++;
				cov[xi] = (*g)[i].m_joint[y][xi] - margi[xi%qi]*margk[yk];
      }

      // get the transposed
      VProb trp(qi*qk);
      for (uint xi = 0, yk = 0; xi < qi*qk; xi++) {
				if (xi && (xi%qi == 0)) yk++;
				trp[xi] = cov[yk+qi*(xi%2)];
      }

      // symmetrize the covs
      for (uint xi = 0; xi < qi*qk; xi++) {
				cov[xi] += trp[xi];
      }
      cov /= 2;
      covi.push_back(cov);

      //      std::cout << "C(COND) " << i << "-" << k << " ";
      //      std::cout << cov << std::endl;
      //      printf("%.15e\n", cov[0]-cov[1]-cov[2]+cov[3]);
      
      y++;
    }
    covs.push_back(covi);
    x++;
  }

  // insert probabilities and covariances in the graph
  uint i = 0;
  for (VectorVertexIt itv = m_vars_labels.begin(); itv != m_vars_labels.end(); itv++){
    for (uint j = 0; j < m_nvars; j++)
      (*g)[*itv].m_cov.push_back(covs[i][j]);
    i++;
  }

  m_method = COND;
  return true;
}

void FGraph::reset()
{
  EdgeIt ei, ei_end;
  for (tie(ei, ei_end) = edges(*g); ei != ei_end; ++ei) {
    (*g)[*ei].m_new.fill(1.); (*g)[*ei].m_old.fill(1.);
    (*g)[*ei].n_new.fill(1.); (*g)[*ei].n_old.fill(1.);
  }
}
