#include "global.hh"

std::ostream& operator<< (std::ostream& os, const VProb& vp)
{
  for (const_vprob_it it = vp.begin(); it != vp.end(); it++)
    os << std::setprecision(PRECISION) << *it << " ";
  return os;
}

std::ostream& operator<< (std::ostream& os, const VectorInt& v)
{
  for (VectorIntCIt it = v.begin(); it != v.end(); it++)
    os << *it << " ";
  return os;
}

std::ostream& operator<< (std::ostream& os, const VectorVProb& vp)
{
  os << endl;
  for (uint i=0; i<vp.size(); i++) {
    os << vp[i];
    os << endl;
  }
  return os;
}


