//
// global.hh
// 
// Made by Vicen Gomez
// Login   <vicen@localhost.localdomain>
// 
// Started on  Mon May 22 15:16:13 2006 Vicen Gomez
// Last update Mon May 22 15:16:13 2006 Vicen Gomez
//

#ifndef   	GLOBAL_HH_
# define   	GLOBAL_HH_

#include <iostream>                      // for std::cout
#include <fstream>                       // for std::cout
#include <sstream>
#include <utility>                       // for std::pair
#include <map>
#include <iomanip>

// for random number generation
// #include <gsl/gsl_rng.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_randist.h>

#include <boost/graph/graph_traits.hpp>
#include <boost/graph/adjacency_list.hpp>

// for limits
#include <float.h>

#include "vprob.hh"
#include "pindex.hh"

#include "ttoc.h"

#include <math.h>

#define STR_BP_SEQFIX "BP_SEQ_FIX"
#define PRECISION      14

using namespace boost;

// forward declarations
class PVertex;   
class PEdge;

/*!
  Type of the graph stored in the FGraph class.
  It is convenient to try with different choices of template
  parameters
 */
typedef adjacency_list<vecS, vecS, undirectedS, PVertex, PEdge, property<edge_index_t, std::size_t> > BGraph;

/*!
  Vertex descriptor for obtaining a PVertex indexing the graph
 */
typedef graph_traits<BGraph>::vertex_descriptor Vertex;

/*!
  Edge descriptor for obtaining a PEdge indexing the graph
 */
typedef graph_traits<BGraph>::edge_descriptor Edge;

typedef graph_traits<BGraph>::vertex_iterator VertexIt;
typedef graph_traits<BGraph>::edge_iterator EdgeIt;
typedef graph_traits<BGraph>::out_edge_iterator OutEdgeIt; 
typedef graph_traits<BGraph>::in_edge_iterator InEdgeIt;
typedef graph_traits<BGraph>::adjacency_iterator AdjIt;

typedef std::multimap<Real, Edge> MapRes;
typedef std::pair<Real, Edge> MapResElem;
typedef MapRes::iterator MapResIt;
typedef std::vector<Real> VectorReal;
typedef std::vector<int> VectorInt;
typedef std::vector<int>::iterator VectorIntIt;
typedef std::vector<int>::const_iterator VectorIntCIt;
typedef std::vector<Vertex> VectorVertex;
typedef std::vector<Edge> VectorEdge;
typedef std::vector<Vertex>::iterator VectorVertexIt;
typedef std::vector<Edge>::iterator VectorEdgeIt;
typedef std::vector<VProb> VectorVProb;
typedef std::vector<VProb>::iterator VectorVProbIt;

/*!
  the type of a vertex:
  - VAR a vertex of type variable
  - FACTOR a vertex of type factor
 */
typedef enum {VAR, FACTOR} TVertex;

/*!
  variants of the bp algorithm:
  - BP_MAXRES selects the next edge with maximum residual
  - BP_SEQFIX selects the next edge according to the original fixed sequence of edges
  - BP_SEQRND selects the next edge according to a random ordering of edges
  - BP_PARAL  paralel updating of the messages
 */
typedef enum {BP_SEQFIX=1, BP_SEQRND=2, BP_PARAL=3, BP_MAXRES=4} TBPVariant;

/*!
  variants of the algorithm used to compute covariance matrices:
  - EXACT1 exact computation using brute force
  - COND   conditioning (see Welling paper)
  - BPLR   response propagation using matrices M, N as messages
 */
typedef enum {EXACT1=1, COND=2, BPLR=3} MethodVariant;

/// The PVertex class

/**
   This class is property of each vertex in the graph
   
 */

class PVertex
{
public:

  TVertex type;
  ///< the type of the pvertex: variable or factor

  int label;
  ///< the label of the pvertex:
  ///< - If variable: the label indicated in the file
  ///< - If factor: labels are assigned sequentially starting from cero

  int size;
  ///< the size of the stored function:
  ///< - If variable: the size of the belief
  ///< - If factor: the size of the potential function

  VProb bel;
  ///< the belief of the pvertex:
  ///< - If variable: the single node marginal BP belief
  ///< - If factor: the BP belief (marginal of included variables)

  VProb p;
  ///< the function of the pvertex:
  ///< - If variable: the exact node marginal
  ///< - If factor: the exact joint marginal of included variables

  VectorVProb bel_tlsbp;
  ///< - If variable: the single node marginal TLSBP belief
  ///< - If factor: the TLSBP belief (marginal of included variables)

  VProb psi;
  ///< the function of the pvertex:
  ///< - If factor: the potential
  ///< - If variable: not used

  PIndex index;
  ///< the indices of the factor
  ///< - If variable: not used

  VectorVProb m_cov;
  ///< the covariances of the node

  VectorVProb m_joint;
  ///< - If variable: the joints obtained using the COND method
  ///< - If factor: not used

  VectorVProb m_cond;
  ///< - If variable: the conditionals obtained using the COND method
  ///< - If factor: not used

  VectorVProb m_R;
  ///< - If variable: the Response matrix (sensitivity of log b_i(x_i) to a change
  //                  in the log node potentials log \phi_j(x_j) )
  ///< - If factor: the Response matrix (sensitivity of log b_\alpha(x_\alpha) to a change
  //                  in the log node potentials log \phi_j(x_j) )

  Real m;
  ///< - If binary variable: BP magnetization = (bel[0] - bel[1])
  ///< - If factor: not used
  
  Real mu;
  ///< - upper bound term for the loop series

  PVertex() {};
  ///< default constructor

  PVertex(const TVertex& _type, const int& _label, const int& _n) :
    type(_type), label(_label), size(_n), bel(_n, 1./_n) {}

  ///< constructor used temporary during the initialization
  ///< \param _type the type of the vertex (VAR or FACTOR)
  ///< \param _label the label of the vertex
  ///< \param _n the size of the statespace

  bool operator < (const PVertex& n) const { return(label < n.label); }
  ///< less operator (needed by std::set)
  
/*  PVertex operator = (const PVertex &v) const
  {
    
  }
*/

};

///< strict weak order based in the cardinality of the variable
struct less_values : public binary_function<const PVertex&, const PVertex&, bool> {
  bool operator()(const PVertex& v1, const PVertex& v2) { return v1.size < v2.size; }
};

/// The PEdge class

/**
   This class is property of each edge in the graph
   
 */
class PEdge
{
public:

  int label;

  /////////////
  // BP members

  VProb m_new;
  ///< the new BP message (factor -> var)

  VProb m_old;
  ///< the old BP message (factor -> var)

  VProb n_new;
  ///< the new BP message (var -> factor)

  VProb n_old;
  ///< the old BP message (var -> factor)

  VProb m0;
  ///< the final BP message (factor -> var)
  ///< UNNORMALIZED (For LR)

  VProb n0;
  ///< the final BP message (var -> factor)
  ///< UNNORMALIZED (For LR)

  int pos_index;
  ///< the position of the variable in the index of the factor

  MapResIt it_residual;
  ///< iterator to access the residual of the message (change between last
  ///< consecutive iterations of the BP algorithm).
  ///< <b>ONLY USED IN THE BP_MAXRES bp_variant</b>

  /////////////
  // LR members

  VProb F;
  ///< precalculated part for fast M calculation

  VProb M;
  ///< the M message (factor -> var)

  VProb N;
  ///< the N message (var -> factor)

  VectorInt indexM;
  ///< the indices of the msg M for marginalization

  //  VProb N;
  ///< the N message (factor -> var)

};

std::ostream& operator<< (std::ostream& os, const VProb& vp);
std::ostream& operator<< (std::ostream& os, const VectorVProb& vp);
std::ostream& operator<< (std::ostream& os, const VectorInt& v);

#endif	    /* !GLOBAL_HH_ */
