//
// LoopGraph.hh
// 
// Made by Vicen Gomez
// Login   <vicen@localhost.localdomain>
// 
// Started on  Tue May 16 10:54:06 2006 Vicen Gomez
// Last update Sat Sep  2 19:34:11 2006 Vicen
//

#ifndef   	LOOPS_HH_
# define   	LOOPS_HH_

#define MAX_BOUND 500            // maximum length for a single loop
#define MAX_COMB  9e7            // maximum number of combinations
#define MAX_LOOP  1000           // for loading loops from a file

//#define HASH_CTE 1000000

#include "fgraph.hh"

#include <ext/hash_map>
using namespace __gnu_cxx; 

namespace __gnu_cxx
{
  template<> struct hash< std::string >
  {
    size_t operator()( const std::string& x ) const
    {
//      std::cout << x << " result is " << hash< const char* >()( x.c_str() ) << std::endl;
      return hash< const char* >()( x.c_str() );
    }
  };
}

typedef unsigned short LVertex;
typedef std::vector<LVertex> VectorLVertex;
typedef std::vector<LVertex>::reverse_iterator VectorLVertexRIt;
typedef std::set<int> SetEdges;
typedef std::set<int>::iterator SetEdgesIt;

class MapLoopElem
{
   public:
        VectorLVertex vloop;
        SetEdges sedges;
        uint length;

        MapLoopElem() {}
	MapLoopElem(const VectorLVertex &_vloop, const SetEdges &_sedges, const uint &_length) {
		vloop = _vloop;
		sedges = _sedges;
		length = _length;
        }
        MapLoopElem &operator=(const MapLoopElem &e) {
                vloop = e.vloop;
                sedges = e.sedges;
                length = e.length;
                return (*this);
        }
};

//typedef unsigned short LVertex;
// typedef unsigned int LVertex;
// typedef Vertex LVertex;

typedef map<std::string, MapLoopElem> MapGloopNew;

typedef std::vector<LVertex>::const_iterator VectorLVertexCIt;

typedef map<std::string, MapLoopElem> MapGLoop;
typedef map<std::string, MapLoopElem>::iterator MapGLoopIt;
typedef map<std::string, MapLoopElem>::const_iterator MapGLoopItC;

typedef map<std::string, std::vector<MapGLoopIt> > MapBLoop;
typedef map<std::string, std::vector<MapGLoopIt> >::iterator MapBLoopIt;

typedef map<__gnu_cxx::hash<std::basic_string<char, std::char_traits<char>, std::allocator<char> > >, int> tHash;

typedef std::pair<LVertex, Real> MuSort;
//typedef std::pair<MapGLoopIt, Real> LoopSort;

typedef std::set<LVertex> SetLVertex;
typedef std::set<LVertex>::iterator SetLVertexIt;
typedef std::set<int> SetEdges;
typedef std::set<int>::iterator SetEdgesIt;

class Term {
public:
  uint vertex;
  Real mu;
  uint q;

  Term(const uint &_v, const Real &_m, const uint &_q) { vertex = _v; mu = _m; q = _q; }
  bool operator < (const Term &t) const { return vertex < t.vertex; }
  //  Term operator = (const Term &t) { vertex = t.vertex; mu = t.mu; q = t.q; return (*this); }
};

typedef std::set<Term> SetTerm;
typedef std::vector<Term> VectorTerm;
typedef std::set<Term>::iterator SetTermIt;
typedef std::vector<Term>::iterator VectorTermIt;

//typedef std::pair<Real, MapGLoopIt> Loop;                      // pair <r, *loop> contained in the vector of loops
class Loop {
public:
  Real       R;
  MapGLoopIt it;
  VectorTerm terms;

  Loop(const Real &_R, const MapGLoopIt &_it, const VectorTerm &_terms) {
    R = _R; it = _it; terms = _terms;
  }
  Loop(const Real &_R, const MapGLoopIt &_it) {
    R = _R; it = _it;
  }
};

// use a Hash instead a rbtree
// typedef std::hash_set<std::string, Loop> HashLoop;
// typedef std::hash_set<std::string, Loop>::iterator HashLoopIt;

// struct LessTerm : public binary_function<const Term &, const Term &, bool> {
//   bool operator()(const Term &a, const Term &b) { return a.vertex < b.vertex; }
// };

struct LessLoop : public binary_function<const Loop &, const Loop &, bool> {
  bool operator()(const Loop &a, const Loop &b) { return fabs(a.R) > fabs(b.R); }
};

//ool operator<(const LoopSort &a, const LoopSort &b) { return a.second < b.second; }

typedef std::vector<uint> VectorUint;

using namespace boost;

class LoopGraph : public FGraph
{
public:

  LoopGraph(std::string filename, TBPVariant bp_variant=BP_SEQFIX):FGraph(filename, bp_variant) { }

  virtual ~LoopGraph();

  bool doLoopSeries(uint S,
                    uint C,
                    uint B,
                    uint M,
										int incr_loops,
                    bool load,
                    bool save,
                    std::string loadfile,
										bool output = false);

  bool doLoopMarginalsClamp(int incr_loops);
  bool doLoopMarginalsLR(int incr_loops);

  Real termsDeriv(Real pleft, uint idx, VectorTerm mu, std::vector<Real> &mur);
  Real factorsDeriv(Real pleft, uint idx, std::vector<Real> &mu, std::vector<Real> &mur);

  Real loopTerm(const VectorLVertex &v, const SetEdges &, VectorTerm &terms, bool get_terms = false);
  Loop gLoopTerm(MapGLoopIt &it, bool get_terms = false);

  Real computeLoopTerms(MapGLoop &loops, bool init=true);

  void printLoop(VectorInt c);
 
  void loop2Dot(const MapGLoopIt &it, const char *filename);

  // given a vector of vars and factors and a set of edges builds the corresponding dot graph
  void buildDotFile(const VectorLVertex &, const VectorLVertex &, const SetEdges &, const char *);

  void countSLoopsDFS(const Vertex &, const Vertex &, const Vertex &, VectorInt *, VectorLVertex *, int, int, int, bool);
  void countSLoops();

  uint mergeLoops(const MapGLoopIt &,
		   const MapGLoopIt &,
		   std::string &,
		   VectorLVertex &,
		   MapGLoop &,
		   const bool &b=false);

  void countGLoops();

  uint countCLoopsDFS(const LVertex &,
		      const LVertex &,
		      const Edge &,
		      std::set<LVertex> &,
		      std::set<int> &,
		      std::vector<std::set<LVertex> > &,
		      std::vector<std::set<int> > &,
		      std::set<int> &,
		      const std::vector<MapGLoopIt> &,
		      MapGLoop &,
		      Real,
		      uint,
		      const uint &,
		      const uint &,
		      bool);

  void updatePairs(const MapGLoopIt &loopit, const Real &term, const VectorTerm &sterm1, const SetLVertex &sloop1);
  
  void saveLoops(std::string filename);
  bool loadLoops(std::string filename);
  bool loadVector(std::string vname, VectorUint &v, std::ifstream &fin);

  void outputVectorFile(char *str, VectorUint &v1, const VectorUint &v2);

  VProb getTLSBPMarginal(uint nloop, int label)
  {
    VProb ret;
    if (nloop < m_loops.size()) {

      ret = (*g)[m_vars_labels[label]].bel_tlsbp[nloop];
    }
    return ret;
  } 

  VectorInt m_marks;                // mark nodes for DFS loop avoidance
  std::vector<bool> m_deleted;      // deleted nodes (do not belong to the 2-core)
  uint m_num_deleted;                // number of deleted nodes (do not belong to the 2-core)

  VectorEdge m_edges;               // vector of all edges indexed by label
  
  vector<uint> m_vsizes;            // vector with nloops per size for sloops
  vector<uint> m_vbsizes_vertices;  // vector with nloops per size for bloops
  vector<uint> m_vbsizes_edges;     // vector with nloops per size for bloops
  vector<uint> m_vgsizes_vertices;  // vector with nloops per size for gloops
  vector<uint> m_vgsizes_edges;     // vector with nloops per size for gloops
  
  MapGLoop m_sloops;                // map to store single loops
  MapGLoop m_gloops;                // map to store generalized loops
  MapBLoop m_bloops;                // map to store branching loops (contains iterators pointing m_sloops and m_gloops)

  uint m_cnbloops;                  // number of complex non-branching loops
  uint m_cbloops;                   // number of complex branching loops
  uint m_ncbloops;                  // number of non-complex branching loops
  uint m_ncnbloops;                 // number of non-complex non-branching (and non-simple) loops

  uint m_nbytes;
  uint m_nvertices;

  uint m_max_length;                // max_length for single loops (in vertices)
  uint m_max_length_found;          // max_length for found single loops (in vertices)
  uint m_steps;

  Real m_logZ_tlsbp;                 // loop corrected partition function
  VectorReal m_error_tlsbp;         // tlsbp error in marginals (for each found loop)
  VectorReal m_error_Ztlsbp;        // tlsbp error in logZ

  vector<Loop> m_loops;             // vector of loops

  vector<Real> m_mus;
  uint m_required;

  uint m_S;                         // number of single loops
  uint m_C;                         // max depth of cloops 

  vector<Real> m_vlogZ_tlsbp;

//  vector<uint> m_hash;

  Real m_cpu_lc;         // cpu-time used counting loops
  Real m_cpu_lcm;        // cpu-time used calculating marginals

	bool m_output_tlsbp;   // output beliefs to a file
protected:

  VectorInt m_g2core;
  VectorInt m_core2g;
  BGraph gcore;                         // original graph (not the 2-core)

  void buildVertex2core();
  void preprocessGraph();

  uint getEdge(const std::string &str, string::size_type &pos, string::size_type &poso)
  {
    pos = str.find("-", poso);
    uint ret = atoi(str.substr(poso, pos-poso).c_str());
    poso = pos+1;
    return ret;
  }

  std::set<int> getEdges(const std::string &key)
  {
    std::set<int> sedges;
    string::size_type poso = 0, pos;
    uint e = getEdge(key, pos, poso);
    while (pos != string::npos) {
      sedges.insert(e);
      e = getEdge(key, pos, poso);
    }
    return sedges;
  }

  std::string createKey(std::vector<int> edges)
  {
    char str_loop[m_nbytes*edges.size()], tmp[m_nbytes];
    str_loop[0] = '\0';
    for (uint i = 0; i < edges.size(); i++) {
      sprintf(tmp, "%d-", edges[i]);
      strcat(str_loop, tmp);
    }
    strcat(str_loop, "\0");
    return std::string(str_loop);
  }

  std::string createKey(std::set<int> edges)
  {
    char str_loop[m_nbytes*edges.size()], tmp[m_nbytes];
    str_loop[0] = '\0';
    for (std::set<int>::iterator i = edges.begin(); i != edges.end(); i++) {
      sprintf(tmp, "%d-", *i);
      strcat(str_loop, tmp);
    }
    strcat(str_loop, "\0");
    return std::string(str_loop);
  }

  uint getSizeLoopEdges(const std::string &key)
  {
    uint size=0, pos1=0, pos2=0;
    pos2 = key.find("-", pos1);
    while (pos2 < key.length()) {
      size++;
      pos1 = pos2+1;
      pos2 = key.find("-", pos1);
    }
    return size;
  }

  int getSizeLoopEdges(MapGLoopIt it) {

    int ret = 0;
    if ((*it).second.vloop.size() == 1) {
      std::vector<MapGLoopIt> itg = m_bloops[(*it).first];
      for (uint l = 0; l < itg.size(); l++) {
        ret += (*itg[l]).second.sedges.size();
      }
    }
    else
      ret = (*it).second.sedges.size();
    return ret;
  }

  void checkType()
  {
    uint nvert = num_vertices(gcore);
    if (sizeof(LVertex) == 1) {
      if (nvert >= UCHAR_MAX) {
	std::cout << "use unsigned short for LVertex: " << UCHAR_MAX << "<" << nvert << std::endl;
	exit(-1);
      }
    }
    else if (sizeof(LVertex) == 2) {
      if (nvert >= USHRT_MAX) {
	std::cout << "use unsigned int for LVertex: " << USHRT_MAX << "<" << nvert << std::endl;
	exit(-1);
      }
    }
    else if (sizeof(LVertex) == 4) {
      if (nvert >= UINT_MAX) {
	std::cout << "too much vertices" << UINT_MAX << "<" << nvert << std::endl;
	exit(-1);
      }
    }
  }

  std::string getLineFile(std::ifstream &fin)
  {
    char buffer[MAX_LOOP];
    std::string strbuf;
    fin.getline(buffer, MAX_LOOP);
    if (strlen(buffer) >= MAX_LOOP) {
      std::cout << "Loading loops file: Increase MAX_LOOP size " << std::endl;
      exit(-1);
    }
    strbuf = buffer;
    return strbuf;
  }

  MapGLoopIt addSLoop(const std::string &key,
                      const VectorLVertex &vloop,
                      const SetEdges &sedges)
  {
    if (vloop.size() == 1) {
      std::cout << "Trying to add a SLoop which is a Disconnected loop" << std::endl;
      exit(-1);
    }
		
		// add the loop into the map
    MapLoopElem newsloop(vloop, sedges, sedges.size());
    m_sloops[key] = newsloop; //vloop;
//    m_hash[m_sloops.hash_funct()(key)%HASH_CTE]++;

    // get the iterator and compute the term
    MapGLoopIt loopit = m_sloops.find(key);
    Loop loop = gLoopTerm(loopit, false);
    m_loops.push_back(loop);

    return loopit;
  }

  // TODO: addGLoop should be the way to add all the loops which are not elementary
  //       call this even when the inserted loop is branching (overload them)
  MapGLoopIt addGLoop(const std::string &key,
                      const VectorLVertex &vloop,
                      const SetEdges &eloop,
                      MapGLoop &new_map)
{
    if (!vloop.size()) {
      std::cout << "Trying to add a GLoop which is NULL?!?!" << std::endl;
      exit(-1);
    }
    if (vloop.size() == 1) {
      std::cout << "Trying to add a GLoop which is a Disconnected loop" << std::endl;
      exit(-1);
    }
    MapGLoopIt itsloop = m_sloops.find(key);
    if (itsloop != m_sloops.end()) {
      std::cout << "Trying to add a GLoop which is a SIMPLE LOOP!" << std::endl;
      exit(-1);
    }

    // add the loop into the map
    MapLoopElem newgloop(vloop, eloop, eloop.size());
    m_gloops[key] = newgloop;
//    m_hash[m_gloops.hash_funct()(key)%HASH_CTE]++;
    new_map[key] = newgloop;

    // get the iterator and compute the term
    MapGLoopIt loopit = m_gloops.find(key);
    Loop loop = gLoopTerm(loopit, false);

    // add the loop to the vector
    if (m_loops.size() < UINT_MAX) 
      m_loops.push_back(loop);
    else {
      std::cout << "UINT_MAX exceeded!" << std::endl;
      exit(-1);
    }
    return loopit;
  }

  uint addDisconnectedLoop(const bool complex,                      // is it a cloop?
                        const VectorLVertex &vloop,              // vector with vertices of the main component of the bloop
                        const SetEdges &eloop,                   // set with edges of the main component of the bloop
                        const std::string &key_comp,             // key of the main component
                        const std::vector<MapGLoopIt> &comps,    // iterators to the components in m_gloops
                        const std::string &key_total,            // key of the entire bloop
			const SetEdges &setotal,                 // set with all the edges of the loop
                        MapGLoop &new_map)                       // new_map where the bloops will also be added
  {
    uint ret = 0;

    MapGLoopIt itloop;
    MapGLoopIt itsloop = m_sloops.find(key_comp);
    MapGLoopIt itgloop = m_gloops.find(key_comp);
    bool add = false;
    if ( (itsloop != m_sloops.end()) && (itgloop != m_gloops.end()) ) {
      std::cout << "component found in both loop structs" << std::endl;
      exit(-1);
    }
    else if ( (itsloop != m_sloops.end()) && (itgloop == m_gloops.end()) ) itloop = itsloop;
    else if ( (itsloop == m_sloops.end()) && (itgloop != m_gloops.end()) ) itloop = itgloop;
    else if ( (itsloop == m_sloops.end()) && (itgloop == m_gloops.end()) ) {
      //std::cout << "component " << key_comp << " not found in both loop structs" << std::endl;
      add = true;
    }

    // debug
    //    new_map[key_comp] = vloop;
    for (uint i = 0;  i < comps.size(); i++) {
      if ((*comps[i]).second.vloop.size() > 1) {
	//	new_map[(*comps[i]).first] = (*comps[i]).second;
      }
      else {
	std::cout << "addDisconnectedLoop: one of the components is a bloop!! ";
	std::cout << (*comps[i]).first << std::endl;
	std::cout << (*comps[i]).second.vloop.size() << std::endl;
	for (uint dd = 0; dd < (*comps[i]).second.vloop.size(); dd++) std::cout << (*comps[i]).second.vloop[dd] << " "; std::cout << std::endl;
	exit(-1);
      }
    }

    // add the main component if necessary
    if (add) {
      itloop = addGLoop(key_comp, vloop, eloop, new_map);
      if (!complex) std::cout << "mygod!" << std::endl;
      ret++;
    }

    if (m_gloops.find(key_total) == m_gloops.end()) {
 
      VectorLVertex dmmy(1,0);
      MapLoopElem loop_dmmy(dmmy, setotal, setotal.size());
      new_map[key_total] = loop_dmmy;
      
      // finally, add the branching loop
      std::vector<MapGLoopIt> all_comps(comps);
      all_comps.push_back(itloop);    

      m_gloops[key_total] = loop_dmmy;
//      m_hash[m_gloops.hash_funct()(key_total)%HASH_CTE]++;
      m_bloops[key_total] = all_comps;
      MapGLoopIt loopit = m_gloops.find(key_total);
      ret++;
      
      // count if it is a complex loop
      if (complex) {
        m_cbloops++;
      }
      else m_ncbloops++;

      // get the term
      Loop bloopt = gLoopTerm(loopit, false);

      // add the loop to the vector
      if (m_loops.size() < UINT_MAX) 
	m_loops.push_back(bloopt);
      else {
	std::cout << "UINT_MAX exceeded!" << std::endl;
	exit(-1);
      }
    }
    return ret;
  }

};


#endif	    /* !LOOPGRAPH_HH_ */
