//
// vprob.cc
//  
// Made by Vicen Gomez
// Login   <vicen@localhost.localdomain>
// 
// Started on  Wed Apr 19 15:28:03 2006 Vicen Gomez
// Started on  Wed Apr 19 15:28:03 2006 Vicen Gomez
//

#include "vprob.hh"

#include <iomanip>
#include <math.h>

void VProb::fill(const Real &init)
{
  for (vprob_it it = begin(); it != end(); it++)
    (*it) = init;
}

void VProb::reset(const uint &newsize, const Real &init)
{
  clear();
  resize(newsize, init);
}

Real VProb::normalizeL1()
{
  Real sum = 0.;
  for (vprob_it it = begin(); it != end(); it++)
    sum += *it;

	if (sum > 0) {
    for (vprob_it it = begin(); it != end(); it++)
      *it /= sum;
	}
  return sum;
}

Real VProb::normalizeLInf()
{
  Real max = 0.;

	for (vprob_it it = begin(); it != end(); it++) {
    max = (fabs(*it) > max) ? fabs(*it) : max;
  }

	if (max == 0.) throw "Z != 0";

  for (vprob_it it = begin(); it != end(); it++) {
    (*it) /= max;
  }

	return max;
}

VProb& VProb::operator= (const VProb& vp)
{
  if (this == &vp) return *this;   // self assignment
  //  if (size() != vp.size()) resize(vp.size());
  std::vector<Real>::operator=(vp);
  return *this;
} 

VProb& VProb::operator*= (const VProb& vp)
{
  const_vprob_it it2 = vp.begin();
  for (vprob_it it1 = begin(); it1 != end(); it1++, it2++)
    (*it1) *= (*it2);
  return *this;
}

VProb& VProb::operator+= (const VProb& vp)
{
  const_vprob_it it2 = vp.begin();
  for (vprob_it it1 = begin(); it1 != end(); it1++, it2++)
    (*it1) += (*it2);
  return *this;
}

VProb& VProb::operator+ (const VProb& vp)
{
  const_vprob_it it2 = vp.begin();
  for (vprob_it it1 = begin(); it1 != end(); it1++, it2++)
    (*it1) += (*it2);
  return *this;
}

VProb& VProb::operator- (const VProb& vp)
{
  const_vprob_it it2 = vp.begin();
  for (vprob_it it1 = begin(); it1 != end(); it1++, it2++)
    (*it1) -= (*it2);
  return *this;
}

VProb& VProb::operator*= (const Real& p)
{
  for (vprob_it it=begin(); it!=end(); it++)
    (*it) *= p;
  return *this;
} 

VProb& VProb::operator/= (const Real& p)
{
  for (vprob_it it=begin(); it!=end(); it++)
    (*it) /= p;
  return *this;
} 

VProb& VProb::operator/ (const Real& p)
{
  for (vprob_it it=begin(); it!=end(); it++)
    (*it) /= p;
  return *this;
} 

Real VProb::mdiff (const VProb& vp)
{
  Real md = 0., d = 0.;
  for (const_vprob_it it1 = begin(), it2 = vp.begin(); it1 != end(); it1++, it2++) {
    d = fabsl((*it1)-(*it2));
    md = (d > md) ? d : md;
  }
  return md;
}

VProb VProb2::marginalize(const int &var)
{
  VProb vmarg(m_sizes[var]);

  if (var)
    for (uint xi=0, yk=0; xi<size(); xi++) {
      if (xi && (xi%m_sizes[0] == 0)) yk++;
      vmarg[yk] += at(xi);
    }
  else
    for (uint xi=0; xi<size(); xi++)
      vmarg[xi%m_sizes[0]] += at(xi);

  return vmarg;
}
