//
// vprob.hh
// 
// Made by Vicen Gomez
// Login   <vicen@localhost.localdomain>
// 
// Started on  Wed Apr 19 15:16:40 2006 Vicen Gomez
// Last update Wed Apr 19 15:16:40 2006 Vicen Gomez
//

/*! 
  \file 
  \brief
 */

#ifndef   	VPROB_HH_
# define   	VPROB_HH_

#include <iostream>
#include <vector>
#include <fstream>
#include <algorithm>
#include "real.hh"
#include <values.h>

/// The VProb class
/**       
   This class implements the basic and frequent operations
   for dealing with a discrete function or vector of values.
   Could it be a message, a potential, a probability distribution ...
   
 */

class VProb : public std::vector<Real>
{

public:

  /// constructor
  /** \param n the number of values
      \param val the initial value
   */
  VProb(const int &n=0, const Real &val=0.) { resize(n, val); }

  /// fills the vector with a value
  /** \param init the value for all the elements
   */
  void fill(const Real &init);

  /// resets all the values and resizes the vector
  /** \param newsize the new size of the vector
      \param init the value for all the elements
   */
  void reset(const uint &newsize, const Real &init);

  /// normalizes the values using the Euclidean norm
  /** details:
      \param sum the sum of all elements after normalization
      \return the obtained normalization factor
   */
  Real normalizeL1();

  /// normalizes the values using the Euclidean Linf
  /** details:
      \param the maximum element
      \return the obtained normalization factor
   */
  Real normalizeLInf();

  /// assignment operator
  /** details:
   */
  VProb& operator= (const VProb& vp);

  /// vector1 - vector2 operator
  /** details:
   */
  VProb& operator- (const VProb& vp);

  /// vector1 + vector2 operator
  /** details:
   */
  VProb& operator+ (const VProb& vp);

  /// vector x real self-product
  /** details:
   */
  VProb& operator*= (const Real& p);

  /// vector / real division
  /** details:
   */
  VProb& operator/ (const Real& p);

  /// vector / real self-division
  /** details:
   */
  VProb& operator/= (const Real& p);

  /// vector x vector self-product
  /** details:
   */
  VProb& operator*= (const VProb& vp);

  /// vector + vector sum
  /** details:
   */
  VProb& operator+= (const VProb& vp);

  /// returns the maximum difference between two vectors
  /** details:
   */
  Real mdiff (const VProb& vp);

  /// outputs the vector to an stream
  /** details:
   */
  friend std::ostream& operator<< (std::ostream& os, const VProb& P);
};

typedef VProb::iterator vprob_it;
/// for iterating the values

typedef VProb::const_iterator const_vprob_it;
/// for const_iterating the values


class VProb2 : public VProb
{

protected:

  std::vector<int> m_sizes;

public:

  VProb2(const int &s1, const int &s2, const Real &val=0.)
  { resize(s1*s2, val); m_sizes.push_back(s1); m_sizes.push_back(s2); }

  /// returns the maximum difference between two vectors
  /** details:
   */
  VProb marginalize(const int &var);

};

#endif	    /* !VPROB_HH_ */
